package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class BetweenExp implements BooleanExpression {

	private final Expression _arg1Exp;
	private final Expression _fromExp;
	private final Expression _toExp;

	public BetweenExp(
		Expression arg1Exp,
		Expression fromExp,
		Expression toExp) {

		Assertion.assertNotNull("arg1Exp", arg1Exp);
		Assertion.assertNotNull("fromExp", fromExp);
		Assertion.assertNotNull("toExp", toExp);

		_arg1Exp = arg1Exp;
		_fromExp = fromExp;
		_toExp = toExp;
	}

	public boolean evaluate(ExprContext context) throws SeasarException {
		Comparable arg1 = (Comparable) _arg1Exp.evaluateValue(context);
		Comparable from = (Comparable) _fromExp.evaluateValue(context);
		Comparable to = (Comparable) _toExp.evaluateValue(context);
		if (arg1 == null || from == null || to == null) {
			return false;
		} else {
			return arg1.compareTo(from) >= 0 && arg1.compareTo(to) <= 0;
		}
	}
}