package org.seasar.expr;

public final class BooleanExp implements BooleanExpression, Expression {

	public static final BooleanExp TRUE = new BooleanExp(true);
	public static final BooleanExp FALSE = new BooleanExp(false);
	private final boolean _value;

	public BooleanExp(boolean value) {
		_value = value;
	}

	public boolean evaluate(ExprContext context) {
		return _value;
	}

	public Object evaluateValue(ExprContext context) {
		return _value ? Boolean.TRUE : Boolean.FALSE;
	}
}