package org.seasar.expr;

import org.seasar.util.MathUtil;
import org.seasar.util.SeasarException;

public final class DivideExp extends AbstractCalculateExp {

	public DivideExp(final Expression arg1Exp, final Expression arg2Exp) {
		super(arg1Exp, arg2Exp);
	}

	public Object evaluateValue(final ExprContext context)
		throws SeasarException {

		return MathUtil.divide(getArg1(context), getArg2(context));
	}
}