package org.seasar.expr;

import org.seasar.util.SeasarException;

public final class EqualExp extends AbstractCompareExp {

	public EqualExp(Expression arg1Exp, Expression arg2Exp) {
		super(arg1Exp, arg2Exp);
	}

	public boolean evaluate(ExprContext ruleContext) throws SeasarException {
		Comparable arg1 = getArg1(ruleContext);
		Comparable arg2 = getArg2(ruleContext);
		if (arg1 == null && arg2 == null) {
			return true;
		} else if (arg1 == null || arg2 == null) {
			return false;
		} else {
			return arg1.compareTo(arg2) == 0;
		}
	}
}
