package org.seasar.expr;

import java.lang.reflect.Array;
import java.util.List;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class GetArrayVariableExp extends AbstractVariableExp {

	private Expression _indexExp;
	
    public GetArrayVariableExp(final String name, final Expression indexExp) {
    	super(name);
		Assertion.assertNotNull("indexExp", indexExp);
    	
        _indexExp = indexExp;
    }

    public Object evaluateValue(final ExprContext context) throws SeasarException {
		Number indexNum = (Number) _indexExp.evaluateValue(context);
		int index = indexNum.intValue();
		Object target = context.getValue(_names[0]);
		for (int i = 1; i < _names.length; ++i) {
			target = ExprUtil.getProperty(target, _names[i]);
		}
		if (target instanceof List) {
			return ((List) target).get(index);
		} else {
			return Array.get(target, index);
		}
    }
}
