package org.seasar.expr;

import org.seasar.util.SeasarException;

public final class GetVariableExp extends AbstractVariableExp {

	public GetVariableExp(final String name) {
		super(name);
	}

	public Object evaluateValue(final ExprContext context)
		throws SeasarException {

		Object target = context.getValue(_names[0]);
		for (int i = 1; i < _names.length; ++i) {
			target = ExprUtil.getProperty(target, _names[i]);
		}
		return target;
	}
}
