package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class InExp implements BooleanExpression {

	private Expression _targetExp;
	private Expression[] _inExps;

	public InExp(Expression targetExp, Expression[] inExps) {
		Assertion.assertNotNull("targetExp", targetExp);
		Assertion.assertNotNull("inExps", inExps);

		_targetExp = targetExp;
		_inExps = inExps;
	}

	public boolean evaluate(ExprContext context) throws SeasarException {
		Comparable target = (Comparable) _targetExp.evaluateValue(context);
		if (target == null) {
			return false;
		}
		for (int i = 0; i < _inExps.length; i++) {
			Expression inArgExp = _inExps[i];
			Comparable inArg = (Comparable) inArgExp.evaluateValue(context);
			if (inArg != null && target.compareTo(inArg) == 0) {
				return true;
			}
		}
		return false;
	}
}
