package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.Conversion;
import org.seasar.util.RegExp;
import org.seasar.util.SeasarException;

public final class MatchExp implements BooleanExpression {

	private final Expression _targetExp;
	private final Expression _patternExp;
	private boolean _ignoreCase = false;

	public MatchExp(Expression targetExp, Expression patternExp) {
		this(targetExp, patternExp, false);
	}

	public MatchExp(
		Expression targetExp,
		Expression patternExp,
		boolean ignoreCase) {

		Assertion.assertNotNull("targetExp", targetExp);
		Assertion.assertNotNull("patternExp", patternExp);

		_targetExp = targetExp;
		_patternExp = patternExp;
		_ignoreCase = ignoreCase;
	}

	public boolean evaluate(final ExprContext context) throws SeasarException {

		String target =
			Conversion.toString(_targetExp.evaluateValue(context), null);
		if (target == null) {
			return false;
		}
		String pattern =
			Conversion.toString(_patternExp.evaluateValue(context), null);
		if (_ignoreCase) {
			return RegExp.matchIgnoreCase(pattern, target);
		} else {
			return RegExp.match(pattern, target);
		}
	}
}
