package org.seasar.expr;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import org.seasar.util.Assertion;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarException;

public final class NewExp implements Expression {

	private final Class _clazz;
	private final Expression[] _argExps;

	public NewExp(final Class clazz, final Expression[] argExps) {
		Assertion.assertNotNull("clazz", clazz);
		Assertion.assertNotNull("argExps", argExps);

		_clazz = clazz;
		_argExps = argExps;
	}

	public Object evaluateValue(final ExprContext ruleContext)
		throws SeasarException {

		if (_argExps.length == 0) {
			return Reflector.newInstance(_clazz);
		} else {
			Object[] args = ExprUtil.evaluateValues(_argExps, ruleContext);
			return newInstance(_clazz.getConstructors(), args);
		}
	}

	private Object newInstance(Constructor[] constructors, Object[] args)
		throws SeasarException {

		outerLoop : for (int i = 0; i < constructors.length; ++i) {
			Class[] paramTypes = constructors[i].getParameterTypes();
			if (paramTypes.length != args.length) {
				continue;
			}
			for (int j = 0; j < args.length; ++j) {
				if (args[j] == null
					|| ExprUtil.isTargetClass(
						paramTypes[j],
						args[j].getClass())) {
					continue;
				}
				continue outerLoop;
			}
			return newInstance(constructors[i], args);
		}
		throw new SeasarException(
			"ESSR0009",
			new Object[] { "constructor", _clazz.getName()});
	}

	private Object newInstance(Constructor constructor, Object[] args)
		throws SeasarException {

		try {
			return constructor.newInstance(args);
		} catch (InvocationTargetException ex) {
			throw SeasarException.convertSeasarException(ex);
		} catch (IllegalAccessException ex) {
			throw SeasarException.convertSeasarException(ex);
		} catch (InstantiationException ex) {
			throw SeasarException.convertSeasarException(ex);
		}
	}
}
