package org.seasar.expr;

import org.seasar.util.SeasarException;

public final class NotEqualExp extends AbstractCompareExp {

	public NotEqualExp(final Expression arg1Exp, final Expression arg2Exp) {
		super(arg1Exp, arg2Exp);
	}

	public boolean evaluate(final ExprContext context) throws SeasarException {
		Comparable arg1 = getArg1(context);
		Comparable arg2 = getArg2(context);
		if (arg1 == null && arg2 == null) {
			return false;
		} else if (arg1 == null || arg2 == null) {
			return true;
		} else {
			return arg1.compareTo(arg2) != 0;
		}
	}
}
