package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class NvlExp implements Expression {

	private final Expression _arg1Exp;
	private final Expression _arg2Exp;

	public NvlExp(final Expression arg1Exp, final Expression arg2Exp) {
		Assertion.assertNotNull("arg1Exp", arg1Exp);
		Assertion.assertNotNull("arg2Exp", arg2Exp);

		_arg1Exp = arg1Exp;
		_arg2Exp = arg2Exp;
	}

	public Object evaluateValue(final ExprContext context)
		throws SeasarException {

		Object arg1 = _arg1Exp.evaluateValue(context);
		Object arg2 = _arg2Exp.evaluateValue(context);
		if (arg1 == null) {
			return arg2;
		} else {
			return arg1;
		}
	}
}
