package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class ToBooleanExp implements Expression {

	private final BooleanExpression _arg1Exp;

	public ToBooleanExp(final BooleanExpression arg1Exp) {
		Assertion.assertNotNull("arg1Exp", arg1Exp);

		_arg1Exp = arg1Exp;
	}

	public Object evaluateValue(final ExprContext context)
		throws SeasarException {

		if (_arg1Exp.evaluate(context)) {
			return Boolean.TRUE;
		} else {
			return Boolean.FALSE;
		}
	}
}
