package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.Conversion;
import org.seasar.util.SeasarException;

public final class ToIntegerExp implements Expression {

	private final Expression _arg1Exp;
	private final String _pattern;

	public ToIntegerExp(final Expression arg1Exp, final String pattern) {
		Assertion.assertNotNull("arg1Exp", arg1Exp);

		_arg1Exp = arg1Exp;
		_pattern = pattern;
	}

	public Object evaluateValue(final ExprContext context)
		throws SeasarException {

		Object o = _arg1Exp.evaluateValue(context);
		return Conversion.toInteger(o, _pattern);
	}
}
