package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.Conversion;
import org.seasar.util.SeasarException;

public final class ToTimestampExp implements Expression {

	private final Expression _arg1Exp;
	private final String _pattern;

	public ToTimestampExp(final Expression arg1Exp, final String pattern) {
		Assertion.assertNotNull("arg1Exp", arg1Exp);

		_arg1Exp = arg1Exp;
		_pattern = pattern;
	}

	public Object evaluateValue(final ExprContext context)
		throws SeasarException {
		Object arg1 = _arg1Exp.evaluateValue(context);
		return Conversion.toTimestamp(arg1, _pattern);
	}
}
