package org.seasar.nazuna;

import org.seasar.expr.AliasConfig;
import org.seasar.expr.AliasConfigManager;
import org.seasar.util.ElementHandler;
import org.seasar.util.XMLHandler;
import org.seasar.util.XMLHandlerParser;
import org.seasar.util.XMLHandlerRule;
import org.xml.sax.Attributes;

public final class AliasConfigBuilder {

	private static XMLHandlerRule _xmlHandlerRule = new XMLHandlerRule();

	static {
		configure();
	}

	private static void configure() {
		setupXMLHandlerRule();
	}

	private AliasConfigBuilder() {
	}

	public static final void parse(final String xmlFileName) {
		XMLHandlerParser.parse(xmlFileName, _xmlHandlerRule);
	}

	private static void setupXMLHandlerRule() {
		_xmlHandlerRule
			.addElementHandler("/aliases/alias", new ElementHandler() {
			public void start(XMLHandler xmlHandler, Attributes attributes) {
				String name = attributes.getValue("name");
				String className = attributes.getValue("className");
				String methodName = attributes.getValue("methodName");
				AliasConfig aliasConfig =
					new AliasConfig(name, className, methodName);
				AliasConfigManager.addAliasConfig(aliasConfig);
			}
		});
	}
}
