package org.seasar.nazuna;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public class RuleBase implements RuleStatementContainer,
		ConstAware {

	protected RuleStatement[] _ruleStatements = RuleStatement.EMPTY_ARRAY;
	private String _name;
	private List _tempRuleStatementList = new ArrayList();
	private Map _consts = new SMap();
	private long _lastModified;
	private NazunaTransAttribute _transAttribute = NazunaTransAttribute.SUPPORTS;
	private InputType _inputType;
	private OutputType _outputType;
	private LocalType _localType;
	
	public RuleBase() {
	}
	
	public final String getName() {
		return _name;
	}
	
	public final void setName(String name) {
		_name = name;
	}
	
	public final RuleStatement[] getRuleStatements() {
		return _ruleStatements;
	}
	
	public final void addRuleStatement(RuleStatement ruleStatement) {
		_tempRuleStatementList.add(ruleStatement);
	}
	
	public final void addRuleStatementDone() {
		_ruleStatements = (RuleStatement[]) _tempRuleStatementList.toArray(
			new RuleStatement[_tempRuleStatementList.size()]);
		_tempRuleStatementList.clear();
		_tempRuleStatementList = null;
	}
	
	public final void addConst(String name, Object value) {
		_consts.put(name, value);
	}
	
	public final Object getConst(String name) {
		return _consts.get(name);
	}
	
	public final boolean containsConst(String name) {
		return _consts.containsKey(name);
	}
	
	public final Map getConsts() {
		return _consts;
	}
	
	public final void addConsts(Map consts) {
		_consts.putAll(consts);
	}
	
	public final long getLastModified() {
		return _lastModified;
	}
	
	final void setLastModified(long lastModified) {
		_lastModified = lastModified;
	}
	
	public final NazunaTransAttribute getTransAttribute() {
		return _transAttribute;
	}
	
	public final void setTransAttribute(NazunaTransAttribute transAttribute) {
		_transAttribute = transAttribute;
	}
	
	public final InputType getInputType() {
		return _inputType;
	}
	
	public final void setInputType(InputType inputType) {
		_inputType = inputType;
	}
	
	public Map createArgs(Map parameters) throws SeasarException {
		if (_inputType == null) {
			return new SMap(1);
		}
		return _inputType.createArgs(parameters);
	}
	
	public boolean containsArgType(String name) {
		if (_inputType == null) {
			return false;
		}
		return _inputType.containsArgType(name);
	}
	
	public final OutputType getOutputType() {
		return _outputType;
	}
	
	public final void setOutputType(OutputType outputType) {
		_outputType = outputType;
	}
	
	public final LocalType getLocalType() {
		return _localType;
	}
	
	public final void setLocalType(LocalType localType) {
		_localType = localType;
	}
	
	public final Map createVars() throws SeasarException {
		Map ret = new SMap(4);
		if (_localType != null) {
			ret = _localType.createVars();
		}
		ret.put(Var.OUT.getName(), Var.OUT);
		return ret;
	}
}