package org.seasar.system;

import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public final class NotificationListenerProxy implements NotificationListener {

	private ObjectName _objectName;
	private NotificationListener _listener;

	public NotificationListenerProxy(ObjectName objectName,  NotificationListener listener) {
      _objectName = objectName;
      _listener = listener;
   }

   public void handleNotification(Notification notification, Object handback) {
      if (notification == null) {
         return;
      }
      notification.setSource(_objectName);
      _listener.handleNotification(notification, handback);
   }
}