package org.seasar.util;

import java.lang.reflect.Method;

public final class PropertyDesc {

	private String _propertyName;
	private Class _propertyType;
	private Method _readMethod;
	private Method _writeMethod;
	
	public PropertyDesc(String propertyName, Class propertyType,
			Method readMethod, Method writeMethod) {
				
		Assertion.assertNotNull("propertyName", propertyName);
		Assertion.assertNotNull("propertyType", propertyType);
		
		_propertyName = propertyName;
		_propertyType = propertyType;
		_readMethod = readMethod;
		_writeMethod = writeMethod;
	}
	
	public final String getPropertyName() {
		return _propertyName;
	}

	public final Class getPropertyType() {
		return _propertyType;
	}
	
	public final Method getReadMethod() {
		return _readMethod;
	}
	
	public final void setReadMethod(Method readMethod) {
		_readMethod = readMethod;
	}
	
	public final Method getWriteMethod() {
		return _writeMethod;
	}
	
	public final void setWriteMethod(Method writeMethod) {
		_writeMethod = writeMethod;
	}
	
	public final Object getValue(Object target) {
		return Reflector.invokeNoException(_readMethod, target, ArrayUtil.EMPTY_OBJECTS);
	}
	
	public final void setValue(Object target, Object value) {
		Reflector.invokeNoException(_writeMethod, target, new Object[]{value});
	}
	
	public final String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("propertyName=");
		buf.append(_propertyName);
		buf.append(",propertyType=");
		buf.append(_propertyType.getName());
		buf.append(",readMethod=");
		buf.append(_readMethod != null ?_readMethod.getName() : "null");
		buf.append(",writeMethod=");
		buf.append(_writeMethod != null ?_writeMethod.getName() : "null");
		return buf.toString();
	}
}
