package test.org.seasar;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import test.org.seasar.jetty.JettyAllTests;
import test.org.seasar.log.LogAllTests;
import test.org.seasar.mbean.MBeanAllTests;
import test.org.seasar.message.MessageAllTests;
import test.org.seasar.naming.NamingAllTests;
import test.org.seasar.system.SystemAllTests;
import test.org.seasar.timer.TimerAllTests;
import test.org.seasar.transaction.TransactionAllTests;
import test.org.seasar.util.UtilAllTests;

public class SeasarAllTests extends TestCase {

    public SeasarAllTests(String name) {
        super(name);
    }

    public static Test suite ( ) {
        TestSuite suite = new TestSuite("Seasar All Tests");
		suite.addTest(JettyAllTests.suite());
        suite.addTest(LogAllTests.suite());
        suite.addTest(MBeanAllTests.suite());
        suite.addTest(MessageAllTests.suite());
        suite.addTest(NamingAllTests.suite());
        suite.addTest(SystemAllTests.suite());
        suite.addTest(TimerAllTests.suite());
        suite.addTest(TransactionAllTests.suite());
        suite.addTest(UtilAllTests.suite());
        return suite;
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{SeasarAllTests.class.getName()});
    }
}