package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.AddExp;
import org.seasar.expr.DoubleExp;
import org.seasar.expr.Expression;
import org.seasar.expr.IntegerExp;
import org.seasar.expr.LongExp;
import org.seasar.expr.NullExp;

public class AddExpTest extends TestCase {

	public AddExpTest(String name) {
		super(name);
	}

	public void testAdd() throws Exception {
		IntegerExp i1Exp = new IntegerExp(new Integer(1));
		IntegerExp i2Exp = new IntegerExp(new Integer(2));
		AddExp exp = new AddExp(i1Exp, i2Exp);
		assertEquals("1", new Integer(3), exp.evaluateValue(null));
	}

	public void testAdd2() throws Exception {
		Expression long1Exp = new LongExp(new Long(1));
		Expression long2Exp = new LongExp(new Long(2));
		AddExp exp = new AddExp(long1Exp, long2Exp);
		assertEquals("1", new Long(3), exp.evaluateValue(null));
	}

	public void testAdd3() throws Exception {
		DoubleExp double1Exp = new DoubleExp(new Double(1));
		DoubleExp double2Exp = new DoubleExp(new Double(2));
		AddExp exp = new AddExp(double1Exp, double2Exp);
		assertEquals("1", new Double(3), exp.evaluateValue(null));
	}

	public void testAdd4() throws Exception {
		IntegerExp i1Exp = new IntegerExp(new Integer(1));
		AddExp exp = new AddExp(i1Exp, NullExp.NULL);
		assertEquals("1", null, exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(AddExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { AddExpTest.class.getName()});
	}
}