package test.org.seasar.expr;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.BooleanExp;
import org.seasar.expr.BooleanExpression;
import org.seasar.expr.CaseExp;
import org.seasar.expr.ExprUtil;
import org.seasar.expr.Expression;
import org.seasar.expr.StringExp;

public class CaseExpTest extends TestCase {

	public CaseExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		List boolExpList = new ArrayList();
		List expList = new ArrayList();
		boolExpList.add(new BooleanExp(false));
		expList.add(new StringExp("111"));
		boolExpList.add(new BooleanExp(true));
		expList.add(new StringExp("222"));
		BooleanExpression[] boolExps =
			ExprUtil.toBooleanExpressionArray(boolExpList);
		Expression[] exps = ExprUtil.toExpressionArray(expList);
		Expression exp = new CaseExp(boolExps, exps);
		assertEquals("1", "222", exp.evaluateValue(null));
	}

	public void testEvaluate2() throws Exception {
		List boolExpList = new ArrayList();
		List expList = new ArrayList();
		boolExpList.add(new BooleanExp(false));
		expList.add(new StringExp("111"));
		BooleanExpression[] boolExps =
			ExprUtil.toBooleanExpressionArray(boolExpList);
		Expression[] exps = ExprUtil.toExpressionArray(expList);
		Expression exp = new CaseExp(boolExps, exps);
		assertEquals("1", null, exp.evaluateValue(null));
	}

	public void testEvaluate3() throws Exception {
		List boolExpList = new ArrayList();
		List expList = new ArrayList();
		boolExpList.add(new BooleanExp(true));
		expList.add(new StringExp("111"));
		boolExpList.add(new BooleanExp(true));
		expList.add(new StringExp("222"));
		BooleanExpression[] boolExps =
			ExprUtil.toBooleanExpressionArray(boolExpList);
		Expression[] exps = ExprUtil.toExpressionArray(expList);
		Expression exp = new CaseExp(boolExps, exps);
		assertEquals("1", "111", exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(CaseExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { CaseExpTest.class.getName()});
	}
}