package test.org.seasar.expr;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.ConcatenateExp;
import org.seasar.expr.ExprUtil;
import org.seasar.expr.Expression;
import org.seasar.expr.IntegerExp;
import org.seasar.expr.StringExp;

public class ConcatenateExpTest extends TestCase {

	public ConcatenateExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		List exps = new ArrayList();
		exps.add(new StringExp("aaa"));
		exps.add(new IntegerExp(new Integer(111)));
		Expression exp = new ConcatenateExp(ExprUtil.toExpressionArray(exps));
		assertEquals("1", "aaa111", exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(ConcatenateExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { ConcatenateExpTest.class.getName()});
	}
}