package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.EqualExp;
import org.seasar.expr.IntegerExp;
import org.seasar.expr.NullExp;

public class EqualExpTest extends TestCase {

	public EqualExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		String s = "1234567890";
		Integer i = new Integer(s);
		IntegerExp iExp = new IntegerExp(i);
		EqualExp eqExp = new EqualExp(iExp, iExp);
		assertEquals("1", true, eqExp.evaluate(null));

		EqualExp eq2Exp = new EqualExp(iExp, NullExp.NULL);
		assertEquals("2", false, eq2Exp.evaluate(null));

		EqualExp eq3Exp = new EqualExp(NullExp.NULL, iExp);
		assertEquals("3", false, eq3Exp.evaluate(null));

		EqualExp eq4Exp = new EqualExp(NullExp.NULL, NullExp.NULL);
		assertEquals("4", true, eq4Exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(EqualExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { EqualExpTest.class.getName()});
	}
}