package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestSuite;


public class ExprAllTests {

	public static void main(String[] args) {
		junit.textui.TestRunner.run(ExprAllTests.class);
	}

	public static Test suite() {
		TestSuite suite = new TestSuite("Test for test.org.seasar.expr");
		//$JUnit-BEGIN$
		suite.addTest(ExprCoreTokenizerTest.suite());
		suite.addTest(AddExpTest.suite());
		suite.addTest(SubtractExpTest.suite());
		suite.addTest(MultiplyExpTest.suite());
		suite.addTest(DivideExpTest.suite());
		suite.addTest(ModExpTest.suite());
		suite.addTest(OrExpTest.suite());
		suite.addTest(AndExpTest.suite());
		suite.addTest(IsFalseExpTest.suite());
		suite.addTest(IsTrueExpTest.suite());
		suite.addTest(EqualExpTest.suite());
		suite.addTest(GreaterEqualExpTest.suite());
		suite.addTest(GreaterThanExpTest.suite());
		suite.addTest(LessEqualExpTest.suite());
		suite.addTest(LessThanExpTest.suite());
		suite.addTest(BetweenExpTest.suite());
		suite.addTest(CaseExpTest.suite());
		suite.addTest(CoalesceExpTest.suite());
		suite.addTest(InExpTest.suite());
		suite.addTest(ConcatenateExpTest.suite());
		suite.addTest(IsNotNullExpTest.suite());
		suite.addTest(IsNullExpTest.suite());
		suite.addTest(LikeExpTest.suite());
		suite.addTest(MatchExpTest.suite());
		suite.addTest(NewArrayExpTest.suite());
		suite.addTest(NewExpTest.suite());
		suite.addTest(NotBetweenExpTest.suite());
		suite.addTest(NotEqualExpTest.suite());
		suite.addTest(NotExpTest.suite());
		suite.addTest(NowExpTest.suite());
		suite.addTest(NullifExpTest.suite());
		suite.addTest(NvlExpTest.suite());
		suite.addTest(ToBigDecimalExpTest.suite());
		suite.addTest(ToBooleanExpTest.suite());
		suite.addTest(ToDoubleExpTest.suite());
		suite.addTest(ToIntegerExpTest.suite());
		suite.addTest(ToLongExpTest.suite());
		suite.addTest(ToStringExpTest.suite());
		suite.addTest(ToTimestampExpTest.suite());
		suite.addTest(GetVariableExpTest.suite());
		suite.addTest(GetArrayVariableExpTest.suite());
		suite.addTest(SetVariableExpTest.suite());
		suite.addTest(SetArrayVariableExpTest.suite());
		suite.addTest(MethodExpTest.suite());
		suite.addTest(ExprStatementParserTest.suite());
		//$JUnit-END$
		return suite;
	}
}
