package test.org.seasar.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.ExprContext;
import org.seasar.expr.ExprContextImpl;
import org.seasar.expr.GetArrayVariableExp;
import org.seasar.expr.IntegerExp;
import org.seasar.util.SMap;

public class GetArrayVariableExpTest extends TestCase {

	public GetArrayVariableExpTest(String name) {
		super(name);
	}

	public void testEvaluateValue() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		String[] strings = new String[] { "bbb" };
		ctx.setValue("strings", strings);
		GetArrayVariableExp exp =
			new GetArrayVariableExp("strings", new IntegerExp(new Integer(0)));
		assertEquals("1", "bbb", exp.evaluateValue(ctx));
	}

	public void testEvaluateValue2() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		List strings = new ArrayList();
		strings.add("bbb");
		ctx.setValue("strings", strings);
		GetArrayVariableExp exp =
			new GetArrayVariableExp("strings", new IntegerExp(new Integer(0)));
		assertEquals("1", "bbb", exp.evaluateValue(ctx));
	}

	public void testEvaluateValue3() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		String[] strings = new String[] { "bbb" };
		Map aaa = new SMap();
		aaa.put("strings", strings);
		ctx.setValue("aaa", aaa);
		GetArrayVariableExp exp =
			new GetArrayVariableExp(
				"aaa.strings",
				new IntegerExp(new Integer(0)));
		assertEquals("1", "bbb", exp.evaluateValue(ctx));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(GetArrayVariableExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { GetArrayVariableExpTest.class.getName()});
	}
}