package test.org.seasar.expr;

import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.ExprContext;
import org.seasar.expr.ExprContextImpl;
import org.seasar.expr.GetVariableExp;
import org.seasar.util.EMap;

public class GetVariableExpTest extends TestCase {

	public GetVariableExpTest(String name) {
		super(name);
	}

	public void testEvaluateValue() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		MyBean myBean = new MyBean();
		ctx.setValue("mybean", myBean);
		GetVariableExp exp = new GetVariableExp("mybean.aaa");
		assertEquals("1", "test", exp.evaluateValue(ctx));
	}

	public void testEvaluateValue2() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		Map map = new EMap();
		map.put("aaa", "test");
		ctx.setValue("map", map);
		GetVariableExp exp = new GetVariableExp("map.aaa");
		assertEquals("1", "test", exp.evaluateValue(ctx));
	}

	public void testEvaluateValue3() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		Map map = new EMap();
		map.put("aaa", "test");
		Map map2 = new EMap();
		map2.put("map", map);
		ctx.setValue("map2", map2);
		GetVariableExp exp = new GetVariableExp("map2.map.aaa");
		assertEquals("1", "test", exp.evaluateValue(ctx));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(GetVariableExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { GetVariableExpTest.class.getName()});
	}

	public static class MyBean {

		private String _aaa = "test";

		public String getAaa() {
			return _aaa;
		}
	}
}