package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.BooleanExpression;
import org.seasar.expr.IntegerExp;
import org.seasar.expr.IsNotNullExp;
import org.seasar.expr.NullExp;

public class IsNotNullExpTest extends TestCase {

	public IsNotNullExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		BooleanExpression exp = new IsNotNullExp(NullExp.NULL);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		IntegerExp arg1Exp = new IntegerExp(new Integer(2));
		BooleanExpression exp = new IsNotNullExp(arg1Exp);
		assertEquals("1", true, exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(IsNotNullExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { IsNotNullExpTest.class.getName()});
	}
}