package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.BooleanExpression;
import org.seasar.expr.Expression;
import org.seasar.expr.LikeExp;
import org.seasar.expr.StringExp;

public class LikeExpTest extends TestCase {

	public LikeExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		Expression arg1Exp = new StringExp("SCOTT");
		BooleanExpression exp = new LikeExp(arg1Exp, arg1Exp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		Expression arg1Exp = new StringExp("SCOTT");
		Expression arg2Exp = new StringExp("_COT_");
		BooleanExpression exp = new LikeExp(arg1Exp, arg2Exp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate3() throws Exception {
		Expression arg1Exp = new StringExp("SCOTT");
		Expression arg2Exp = new StringExp("SC%");
		BooleanExpression exp = new LikeExp(arg1Exp, arg2Exp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate4() throws Exception {
		Expression arg1Exp = new StringExp("SCOTT");
		Expression arg2Exp = new StringExp("%TT");
		BooleanExpression exp = new LikeExp(arg1Exp, arg2Exp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate5() throws Exception {
		Expression arg1Exp = new StringExp("SCOTT");
		Expression arg2Exp = new StringExp("S_O%T");
		BooleanExpression exp = new LikeExp(arg1Exp, arg2Exp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate6() throws Exception {
		Expression arg1Exp = new StringExp("SCOTT");
		Expression arg2Exp = new StringExp("COTT");
		BooleanExpression exp = new LikeExp(arg1Exp, arg2Exp);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate7() throws Exception {
		Expression arg1Exp = new StringExp("SCOTT");
		Expression arg2Exp = new StringExp("_COT");
		BooleanExpression exp = new LikeExp(arg1Exp, arg2Exp);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate8() throws Exception {
		Expression arg1Exp = new StringExp("SCOTT");
		Expression arg2Exp = new StringExp("SC%A");
		BooleanExpression exp = new LikeExp(arg1Exp, arg2Exp);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate9() throws Exception {
		Expression arg1Exp = new StringExp("SCOTT");
		Expression arg2Exp = new StringExp("%OT");
		BooleanExpression exp = new LikeExp(arg1Exp, arg2Exp);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate10() throws Exception {
		Expression arg1Exp = new StringExp("SCOTT");
		Expression arg2Exp = new StringExp("SCOTT%");
		BooleanExpression exp = new LikeExp(arg1Exp, arg2Exp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate11() throws Exception {
		Expression arg1Exp = new StringExp("SCOTT");
		Expression arg2Exp = new StringExp("SCOTT_");
		BooleanExpression exp = new LikeExp(arg1Exp, arg2Exp);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate12() throws Exception {
		Expression arg1Exp = new StringExp("SCOTT");
		Expression arg2Exp = new StringExp("%SCOTT");
		BooleanExpression exp = new LikeExp(arg1Exp, arg2Exp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate13() throws Exception {
		Expression arg1Exp = new StringExp("SCOTT");
		Expression arg2Exp = new StringExp("%SCOTT%");
		BooleanExpression exp = new LikeExp(arg1Exp, arg2Exp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate14() throws Exception {
		Expression arg1Exp = new StringExp("SCOTT");
		Expression arg2Exp = new StringExp("S%");
		BooleanExpression exp = new LikeExp(arg1Exp, arg2Exp);
		assertEquals("1", true, exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(LikeExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { LikeExpTest.class.getName()});
	}
}