package test.org.seasar.expr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.DoubleExp;
import org.seasar.expr.ExprContext;
import org.seasar.expr.ExprContextImpl;
import org.seasar.expr.ExprUtil;
import org.seasar.expr.Expression;
import org.seasar.expr.GetVariableExp;
import org.seasar.expr.IntegerExp;
import org.seasar.expr.MethodExp;

public class MethodExpTest extends TestCase {

	public MethodExpTest(String name) {
		super(name);
	}

	public static String foo(Object o) {
		return o.toString();
	}

	public void testEvaluateValue() throws Exception {
		List argExps = new ArrayList();
		argExps.add(new IntegerExp(new Integer(1)));
		Expression exp =
			new MethodExp(
				"java.lang.String",
				"valueOf",
				ExprUtil.toExpressionArray(argExps));
		assertEquals("1", "1", exp.evaluateValue(null));
	}

	public void testEvaluateValue2() throws Exception {
		List argExps = new ArrayList();
		argExps.add(new DoubleExp(new Double(4)));
		Expression exp =
			new MethodExp(
				"java.lang.Math",
				"sqrt",
				ExprUtil.toExpressionArray(argExps));
		assertEquals("1", new Double(2.0), exp.evaluateValue(null));
	}

	public void testEvaluateValue3() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		List argExps = new ArrayList();
		Expression exp =
			new MethodExp(
				"str",
				"toUpperCase",
				ExprUtil.toExpressionArray(argExps));
		ctx.setValue("str", "abc");
		assertEquals("1", "ABC", exp.evaluateValue(ctx));
	}

	public void testEvaluateValue4() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		List argExps = new ArrayList();
		argExps.add(new GetVariableExp("a"));
		Expression exp =
			new MethodExp(
				"test.org.seasar.expr.MethodExpTest",
				"foo",
				ExprUtil.toExpressionArray(argExps));
		ctx.setValue("a", "abc");
		assertEquals("1", "abc", exp.evaluateValue(ctx));
	}

	public void testEvaluateValue5() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		Expression exp =
			new MethodExp("a.b", "toUpperCase", Expression.EMPTY_EXPRESSIONS);
		Map a = new HashMap();
		a.put("b", "abc");
		ctx.setValue("a", a);
		assertEquals("1", "ABC", exp.evaluateValue(ctx));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(MethodExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { MethodExpTest.class.getName()});
	}
}