package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.DoubleExp;
import org.seasar.expr.IntegerExp;
import org.seasar.expr.LongExp;
import org.seasar.expr.ModExp;

public class ModExpTest extends TestCase {

	public ModExpTest(String name) {
		super(name);
	}

	public void testMod() throws Exception {
		IntegerExp i1Exp = new IntegerExp(new Integer(5));
		IntegerExp i2Exp = new IntegerExp(new Integer(2));
		ModExp exp = new ModExp(i1Exp, i2Exp);
		assertEquals("1", new Integer(1), exp.evaluateValue(null));
	}

	public void testMod2() throws Exception {
		LongExp long1Exp = new LongExp(new Long(5));
		LongExp long2Exp = new LongExp(new Long(2));
		ModExp exp = new ModExp(long1Exp, long2Exp);
		assertEquals("1", new Long(1), exp.evaluateValue(null));
	}

	public void testMod3() throws Exception {
		DoubleExp double1Exp = new DoubleExp(new Double(5));
		DoubleExp double2Exp = new DoubleExp(new Double(2));
		ModExp exp = new ModExp(double1Exp, double2Exp);
		assertEquals("1", new Double(1), exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(ModExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { ModExpTest.class.getName()});
	}
}