package test.org.seasar.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.ExprContext;
import org.seasar.expr.ExprContextImpl;
import org.seasar.expr.IntegerExp;
import org.seasar.expr.SetArrayVariableExp;
import org.seasar.expr.StringExp;
import org.seasar.util.SMap;

public class SetArrayVariableExpTest extends TestCase {

	public SetArrayVariableExpTest(String name) {
		super(name);
	}

	public void testEvaluateValue() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		String[] strings = new String[1];
		ctx.setValue("strings", strings);
		SetArrayVariableExp exp =
			new SetArrayVariableExp(
				"strings",
				new IntegerExp(new Integer(0)),
				new StringExp("bbb"));
		assertEquals("1", "bbb", exp.evaluateValue(ctx));
		assertEquals("2", "bbb", strings[0]);
	}

	public void testEvaluateValue2() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		List strings = new ArrayList();
		ctx.setValue("strings", strings);
		SetArrayVariableExp exp =
			new SetArrayVariableExp(
				"strings",
				new IntegerExp(new Integer(0)),
				new StringExp("bbb"));
		assertEquals("1", "bbb", exp.evaluateValue(ctx));
		assertEquals("2", "bbb", strings.get(0));
	}

	public void testEvaluateValue3() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		String[] strings = new String[1];
		Map aaa = new SMap();
		aaa.put("strings", strings);
		ctx.setValue("aaa", aaa);
		SetArrayVariableExp exp =
			new SetArrayVariableExp(
				"aaa.strings",
				new IntegerExp(new Integer(0)),
				new StringExp("bbb"));
		assertEquals("1", "bbb", exp.evaluateValue(ctx));
		assertEquals("2", "bbb", strings[0]);
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(SetArrayVariableExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { SetArrayVariableExpTest.class.getName()});
	}
}