package test.org.seasar.expr;

import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.ExprContext;
import org.seasar.expr.ExprContextImpl;
import org.seasar.expr.SetVariableExp;
import org.seasar.expr.StringExp;
import org.seasar.util.EMap;

public class SetVariableExpTest extends TestCase {

	public SetVariableExpTest(String name) {
		super(name);
	}

	public void testEvaluateValue() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		MyBean myBean = new MyBean();
		ctx.setValue("mybean", myBean);
		SetVariableExp varExp =
			new SetVariableExp("mybean.aaa", new StringExp("bbb"));
		assertEquals("1", "bbb", varExp.evaluateValue(ctx));
		assertEquals("2", "bbb", myBean.getAaa());
	}

	public void testEvaluateValue2() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		Map map = new EMap();
		map.put("aaa", "test");
		ctx.setValue("map", map);
		SetVariableExp varExp =
			new SetVariableExp("map.aaa", new StringExp("bbb"));
		assertEquals("1", "bbb", varExp.evaluateValue(ctx));
		assertEquals("2", "bbb", map.get("aaa"));
	}

	public void testEvaluateValue3() throws Exception {
		ExprContext ctx = new ExprContextImpl();
		Map map = new EMap();
		map.put("aaa", "test");
		Map map2 = new EMap();
		map2.put("map", map);
		ctx.setValue("map2", map2);
		SetVariableExp varExp =
			new SetVariableExp("map2.map.aaa", new StringExp("bbb"));
		assertEquals("1", "bbb", varExp.evaluateValue(ctx));
		assertEquals("2", "bbb", map.get("aaa"));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(SetVariableExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { SetVariableExpTest.class.getName()});
	}

	public static class MyBean {

		private String _aaa = "test";

		public String getAaa() {
			return _aaa;
		}

		public void setAaa(String aaa) {
			_aaa = aaa;
		}
	}
}