package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.BooleanExp;
import org.seasar.expr.BooleanExpression;
import org.seasar.expr.Expression;
import org.seasar.expr.ToBooleanExp;

public class ToBooleanExpTest extends TestCase {

	public ToBooleanExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		BooleanExpression argExp = new BooleanExp(true);
		Expression exp = new ToBooleanExp(argExp);
		assertEquals("1", Boolean.TRUE, exp.evaluateValue(null));
	}

	public void testEvaluate2() throws Exception {
		BooleanExpression argExp = new BooleanExp(false);
		Expression exp = new ToBooleanExp(argExp);
		assertEquals("1", Boolean.FALSE, exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(ToBooleanExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { ToBooleanExpTest.class.getName()});
	}
}