package test.org.seasar.expr;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.DoubleExp;
import org.seasar.expr.Expression;
import org.seasar.expr.StringExp;
import org.seasar.expr.ToStringExp;
import org.seasar.expr.ToTimestampExp;

public class ToStringExpTest extends TestCase {

	public ToStringExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		Expression exp = new ToStringExp(new DoubleExp(new Double(1)), "000");
		assertEquals("1", "001", exp.evaluateValue(null));

		Expression exp2 =
			new ToStringExp(
				new ToTimestampExp(new StringExp("20021114"), "yyyyMMdd"),
				"yyyy/MM/dd");
		assertEquals("2", "2002/11/14", exp2.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(ToStringExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { ToStringExpTest.class.getName()});
	}
}