package test.org.seasar.message;

import junit.framework.*;
import org.seasar.message.*;


public class MessageFormatterTest extends TestCase {

    public MessageFormatterTest(String name) {
        super(name);
    }

    public void testGetConfig() throws Exception {
        assertNotNull("1", MessageFormatter.getConfig());
    }

    public void testGetSubSystem() throws Exception {
        assertEquals("1", "SSR", MessageFormatter.getSubSystem("ISSR0001"));
    }

    public void testGetMessages() throws Exception {
        assertNotNull("1", MessageFormatter.getMessages("SSR"));
        assertNull("2", MessageFormatter.getMessages("XXX"));
    }

    public void testGetPattern() throws Exception {
        assertNotNull("1", MessageFormatter.getPattern("ISSR0001"));
        assertNull("2", MessageFormatter.getPattern("IXXX0001"));
        assertNull("3", MessageFormatter.getPattern("ISSRXXXX"));
    }

    public void testGetNoPatternMessage() throws Exception {
        assertEquals("1", "", MessageFormatter.getNoPatternMessage(new Object[0]));
        assertEquals("2", "", MessageFormatter.getNoPatternMessage(null));
        assertEquals("3", "aaa, bbb", MessageFormatter.getNoPatternMessage(new Object[]{"aaa", "bbb"}));
    }

    public void testGetSimpleMessage() throws Exception {
        assertEquals("1", "seasar started", MessageFormatter.getSimpleMessage("ISSR0001", null));
        assertEquals("2", "test", MessageFormatter.getSimpleMessage("EXXX0003", new Object[]{"test"}));
    }

    public void testGetMessage() throws Exception {
        //assertEquals("1", "[ISSR0001]seasar started", MessageFormatter.getMessage("ISSR0001", null));
        assertEquals("2", "[EXXX0003]test", MessageFormatter.getMessage("EXXX0003", new Object[]{"test"}));
		assertEquals("3", "[]", MessageFormatter.getMessage(null, null));
    }
    
	public void testSetup() throws Exception {
		try {
			MessageFormatter.clear();
			MessageFormatter.setConfigFile("test.org.seasar.message.message-config");
			MessageFormatter.setup();
			assertEquals("1", "Hoge", MessageFormatter.getSimpleMessage("EABC0001", null));
		} finally {
			MessageFormatter.clear();
			MessageFormatter.setConfigFile("message-config");
			MessageFormatter.setup();
		}
	}

    protected void setUp() throws Exception {
    }


    protected void tearDown() throws Exception {
    }


    public static Test suite() {
        return new TestSuite(MessageFormatterTest.class);
    }


    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{MessageFormatterTest.class.getName()});
    }
}
