package test.org.seasar.nazuna;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.FilterDesc;
import org.seasar.util.SMap;

public class FilterDescTest extends TestCase {

	private List _items;
	
    public FilterDescTest(String name) {
        super(name);
    }
    
    public void testFilter() throws Exception {
    	FilterDesc filterDesc = new FilterDesc("item.b = 'b1'");
    	List ret = filterDesc.filter(_items);
    	assertEquals("1", 2, ret.size());
    	Map item = (Map) ret.get(0);
    	assertEquals("2", "a1", item.get("a"));
    	assertEquals("3", "b1", item.get("b"));
    	
    	item = (Map) ret.get(1);
    	assertEquals("4", "a2", item.get("a"));
    	assertEquals("5", "b1", item.get("b"));
    }
    
    public void testFilter2() throws Exception {
    	FilterDesc filterDesc = new FilterDesc("item.b = b");
    	Map parameters = new SMap();
    	parameters.put("b", "b1");
    	List ret = filterDesc.filter(_items, parameters);
    	assertEquals("1", 2, ret.size());
    	Map item = (Map) ret.get(0);
    	assertEquals("2", "a1", item.get("a"));
    	assertEquals("3", "b1", item.get("b"));
    	
    	item = (Map) ret.get(1);
    	assertEquals("4", "a2", item.get("a"));
    	assertEquals("5", "b1", item.get("b"));
    }
    
    public void testFilterFirst() throws Exception {
    	FilterDesc filterDesc = new FilterDesc("item.b = 'b1'");
    	Map item = (Map) filterDesc.filterFirst(_items);
    	assertEquals("1", "a1", item.get("a"));
    	assertEquals("2", "b1", item.get("b"));
    }
    
    public void testFilterFirst2() throws Exception {
    	FilterDesc filterDesc = new FilterDesc("item.b = b");
    	Map parameters = new SMap();
    	parameters.put("b", "b1");
    	Map item = (Map) filterDesc.filterFirst(_items, parameters);
    	assertEquals("1", "a1", item.get("a"));
    	assertEquals("2", "b1", item.get("b"));
    }
    
    protected void setUp() throws Exception {
    	_items = new ArrayList();
    	Map item = new HashMap();
    	item.put("a", "a1");
    	item.put("b", "b1");
    	_items.add(item);
    	item = new HashMap();
    	item.put("a", "a2");
    	item.put("b", "b1");
    	_items.add(item);
    	item = new HashMap();
    	item.put("a", "a3");
    	item.put("b", "b3");
    	_items.add(item);
    	
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(FilterDescTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{FilterDescTest.class.getName()});
    }
}