package test.org.seasar.nazuna;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.Flowlet;
import org.seasar.nazuna.RuleStatement;
import org.seasar.nazuna.StmtTag;
import org.seasar.expr.ExprUtil;
import org.seasar.expr.Expression;
import org.seasar.expr.MethodExp;
import org.seasar.expr.StringExp;

public class RuleTest extends TestCase {

	public RuleTest(String name) {
		super(name);
	}

	public void testExecute() throws Exception {
		Flowlet rule = new Flowlet();
		List argExps = new ArrayList();
		argExps.add(new StringExp("a\\b"));
		Expression exp =
			new MethodExp(
				"out",
				"println",
				ExprUtil.toExpressionArray(argExps));
		RuleStatement stmt = new StmtTag(rule, "/rule[1]/stmt[1]", exp);
		rule.addRuleStatement(stmt);
		rule.addRuleStatementDone();
		rule.execute();
	}

	public void testFindAncestor() throws Exception {
		Flowlet rule = new Flowlet();
		List argExps = new ArrayList();
		argExps.add(new StringExp("Hello"));
		Expression exp =
			new MethodExp(
				"out",
				"println",
				ExprUtil.toExpressionArray(argExps));
		RuleStatement stmt = new StmtTag(rule, "/rule[1]/stmt[1]", exp);
		rule.addRuleStatement(stmt);
		assertEquals("1", rule, stmt.findAncestor(Flowlet.class));
		assertEquals("2", null, stmt.findAncestor(StmtTag.class));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(RuleTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(new String[] { RuleTest.class.getName()});
	}
}