package test.org.seasar.nazuna;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.expr.ExprUtil;
import org.seasar.expr.Expression;
import org.seasar.expr.NewArrayExp;
import org.seasar.expr.NewExp;
import org.seasar.expr.StringExp;
import org.seasar.nazuna.ThrowTag;
import org.seasar.util.SeasarException;

public class ThrowTagTest extends TestCase {

	public ThrowTagTest(String name) {
		super(name);
	}

	public void testGetThrowable() throws Exception {
		ThrowTag throwTag = new ThrowTag(null, null);
		List argExpList = new ArrayList();
		argExpList.add(new StringExp("ESSR0007"));
		argExpList.add(
			new NewArrayExp(
				Object.class,
				1,
				new Expression[] { new StringExp("foo")}));
		Expression throwableExp =
			new NewExp(
				SeasarException.class,
				ExprUtil.toExpressionArray(argExpList));
		throwTag.setThrowableExp(throwableExp);
		SeasarException se = (SeasarException) throwTag.getThrowable(null);
		System.out.println(se);
		assertNotNull("1", se);
		assertEquals("2", "ESSR0007", se.getMessageCode());
	}

	public void testGetThrowable2() throws Exception {
		ThrowTag throwTag = new ThrowTag(null, null);
		throwTag.setMessageCode("ESSR0007");
		throwTag.setArgs("'foo'");
		SeasarException se = (SeasarException) throwTag.getThrowable(null);
		System.out.println(se);
		assertNotNull("1", se);
		assertEquals("2", "ESSR0007", se.getMessageCode());
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(ThrowTagTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { ThrowTagTest.class.getName()});
	}
}