package test.org.seasar.nazuna.amf;

import java.util.*;
import org.seasar.nazuna.amf.*;

import junit.framework.TestCase;

public class AMFGatewayTest extends TestCase {
	
	private AMFGateway _gateway = new AMFGateway();
	
	public AMFGatewayTest(String arg0) {
		super(arg0);
	}
	
	public void testProcessBodyRulet() throws Exception {
		String target = "test.org.seasar.nazuna.AddRulet.executeRulet";
		List value = new ArrayList();
		value.add("1");
		value.add("2");
		AMFBody requestBody = new AMFBody(target, "response", value);
		AMFBody responseBody = _gateway.processBody(null, requestBody);
		assertEquals("1", "response/onResult", responseBody.getTarget());
		assertEquals("2", new Integer(3), responseBody.getValue());
	}
	
	public void testProcessBodyError() throws Exception {
		String target = "test.org.seasar.nazuna.AddRulet.executeRulet";
		List value = new ArrayList();
		value.add("hoge");
		value.add("2");
		AMFBody requestBody = new AMFBody(target, "response", value);
		AMFBody responseBody = _gateway.processBody(null, requestBody);
		assertEquals("1", "response/onStatus", responseBody.getTarget());
		AMFError error = (AMFError) responseBody.getValue();
		System.out.println(error.getDetails());
	}
	
	public void testProcessBodyFlowlet() throws Exception {
		String target = "test.org.seasar.nazuna.AddFlowlet.execute";
		List value = new ArrayList();
		value.add("1");
		value.add("2");
		AMFBody requestBody = new AMFBody(target, "response", value);
		AMFBody responseBody = _gateway.processBody(null, requestBody);
		assertEquals("1", "response/onResult", responseBody.getTarget());
		assertEquals("2", new Integer(3), responseBody.getValue());
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(AMFGatewayTest.class);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

}
