// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip
//
//
/*
//
CheckoutUI class

	The CheckoutUI class encapsulates all UI behavior pertaining to the
	checkout experience.

	This is meant to be used as a singleton: i.e. It's not meant to be
	instantiated directly and all access should go through the
	_global.checkoutWidget_mc object.

	This file is associated with a library movie clip symbol.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class

			Frame:				1

			Library Symbol:		checkoutWidget_mc

			Library Path:		CheckoutWidget/checkoutWidget_mc
//
*/
//

function CheckoutUI() {
	_global.checkoutWidget_mc = this;
}

Object.registerClass("CheckoutSymbol", CheckoutUI);


CheckoutUI.prototype = new MovieClip();

CheckoutUI.prototype.init = function(tabController, widgetGroup, strings, cart, user) {
	this.tabController = tabController;
	this.tabCt = TabConstants.prototype.CheckoutUIStartTab;
	this.widgetGroup = widgetGroup;
	this.strings = strings;
	this.cart = cart;
	this.user = user;
 	this.sharedAddressFields_array = ["firstname", "firstNameFld_mc",
							"lastname", "lastNameFld_mc",
							"street1", "addressFld_mc", 
							"city", "cityFld_mc", 
							"state", "state_cb", 
							"country", "country_cb", 
							"zip", "zipCodeFld_mc", 
							"phone", "phoneFld_mc"];
	this.shareAddresses = true;
	this.head_txt.text = this.strings.CHECKOUT_GROUP_HD_str;
	_global.sizeAndFormatIconBtn(this.continueShopping_ib, this.strings.CHECKOUT_EXIT_BTN_LBL_str, _global.formIconBtnFormat, true);
	this.continueShopping_ib.setChangeHandler("continueShopping", this);
	this.tabController.setTab("CheckoutUI", this.continueShopping_ib, this.tabCt++);

	this.loginPending = false;

	this.profileFlds_mc._visible = false;
	this.billingFlds_mc._visible = false;
	this.shippingFlds_mc._visible = false;
	this.shippingMethodFlds_mc._visible = false;
	this.paymentFlds_mc._visible = false;

	this.onEnterFrame = CheckoutUI.prototype.profileFldsInit;
}


CheckoutUI.prototype.profileFldsInit = function() {
	this.profileFlds_mc.sectionHead_txt.text = this.strings.CHECKOUT_USER_HD_str;
	this.profileFlds_mc.headBG_mc.onPress = CheckoutUI.prototype.widgetBtnPressed;
	this.profileFlds_mc.headBG_mc.widget_mc = this.profileFlds_mc;
	this.profileFlds_mc.openContent_mc.init(this.tabcontroller,
						TabConstants.prototype.ProfileUIStartTab + 1, this.strings, this,
						this.user);
	this.profileFlds_mc._visible = true;
	this.onEnterFrame = CheckoutUI.prototype.billingFldsInit;
}


CheckoutUI.prototype.billingFldsInit = function() {
	this.billingFlds_mc.sectionHead_txt.text = this.strings.CHECKOUT_BILLING_HD_str;
	this.billingFlds_mc.openContent_mc.isBilling = true;
	this.billingFlds_mc.openContent_mc.continue_ib.onPress = CheckoutUI.prototype.validateAddressesAndContinue;
	this.billingFlds_mc.openContent_mc.continue_ib.checkout = this;
	this.billingFlds_mc.headBG_mc.onPress = CheckoutUI.prototype.widgetBtnPressed;
	this.billingFlds_mc.headBG_mc.widget_mc = this.billingFlds_mc;
	this.billingFlds_mc.openContent_mc.init(this.tabcontroller,
			TabConstants.prototype.BillingFieldsUIStartTab + 1, this.strings,
			this);
	this.billingFlds_mc._visible = true;
	this.onEnterFrame = CheckoutUI.prototype.shippingFldsInit;
}


CheckoutUI.prototype.shippingFldsInit = function() {
	this.shippingFlds_mc.sectionHead_txt.text = this.strings.CHECKOUT_SHIPPING_HD_str;
	this.shippingFlds_mc.openContent_mc.isBilling = false;
	this.shippingFlds_mc.openContent_mc.continue_ib.onPress = CheckoutUI.prototype.validateAddressesAndContinue;
	this.shippingFlds_mc.openContent_mc.continue_ib.checkout = this;
	this.shippingFlds_mc.headBG_mc.onPress = CheckoutUI.prototype.widgetBtnPressed;
	this.shippingFlds_mc.headBG_mc.widget_mc = this.shippingFlds_mc;
	this.shippingFlds_mc.openContent_mc.init(this.tabcontroller,
			TabConstants.prototype.ShippingFieldsUIStartTab + 1, this.strings,
			this);
	this.shippingFlds_mc._visible = true;
	this.onEnterFrame = CheckoutUI.prototype.shippingMethodsInit;
}


CheckoutUI.prototype.shippingMethodsInit = function() {
	this.shippingMethodFlds_mc.sectionHead_txt.text = this.strings.CHECKOUT_SHIPPING_METHOD_HD_str;
	this.shippingMethodFlds_mc.headBG_mc.onPress = CheckoutUI.prototype.widgetBtnPressed;
	this.shippingMethodFlds_mc.headBG_mc.widget_mc = this.shippingMethodFlds_mc;
	this.shippingMethodFlds_mc.openContent_mc.init(this.tabcontroller,
			TabConstants.prototype.ShippingMethodsUIStartTab + 1, this.strings, this.cart.getShippingMethods(),
			this);
	this.shippingMethodFlds_mc._visible = true;
	this.onEnterFrame = CheckoutUI.prototype.paymentFldsInit;
}

CheckoutUI.prototype.paymentFldsInit = function() {
	this.paymentFlds_mc.sectionHead_txt.text = this.strings.CHECKOUT_PAYMENT_HD_str;
	this.paymentFlds_mc.headBG_mc.onPress = CheckoutUI.prototype.widgetBtnPressed;
	this.paymentFlds_mc.headBG_mc.widget_mc = this.paymentFlds_mc;
	this.paymentFlds_mc.openContent_mc.init(this.tabcontroller,
			TabConstants.prototype.PaymentMethodsUIStartTab + 1, this.strings,
			this);
	this.paymentFlds_mc._visible = true;
	this.onEnterFrame = CheckoutUI.prototype.completeInit;
}

CheckoutUI.prototype.completeInit= function() {
	this.widgetGroup.toggleWidget(this.profileFlds_mc);
	this.currSection = this.profileFlds_mc;
	delete this.onEnterFrame;
}

CheckoutUI.prototype.startListening = function() {
	seasar.event.Broadcaster.addEventListener("updateTotalCost", this);
	seasar.event.Broadcaster.addEventListener("addUser", this);
	seasar.event.Broadcaster.addEventListener("addUserStatus", this);
	seasar.event.Broadcaster.addEventListener("getUser", this);
	seasar.event.Broadcaster.addEventListener("getUserStatus", this);
	seasar.event.Broadcaster.addEventListener("updateUser", this);
	seasar.event.Broadcaster.addEventListener("updateUserStatus", this);
}

CheckoutUI.prototype.updateTotalCostPerformed = function(data) {
	this.paymentFlds_mc.openContent_mc.grandTotal_txt.text = _global.formatForCurrency(data);
}

CheckoutUI.prototype.getUserPerformed = function(data) {
	this.loginPending = false;
	this.progBox._visible = false;
	this.restoreUser(data);
	this.doNext(this.profileFlds_mc);
}

CheckoutUI.prototype.getUserStatusPerformed = function(data) {
	this.loginPending = false;
	this.profileFlds_mc.openContent_mc.loginFailed(this.strings.VALIDATE_LOGIN_USER_FAILED_TITLE_str, this.strings.VALIDATE_LOGIN_USER_FAILED_MSG_str);
}

CheckoutUI.prototype.updateUserPerformed = function(data) {
	this.continueSendOrder();
}

CheckoutUI.prototype.updateUserStatusPerformed = function(data) {
	this.continueSendOrder();
}

CheckoutUI.prototype.addUserPerformed = function(data) {
	this.loginPending = false;
	this.gotUserData(data);
}

CheckoutUI.prototype.addUserStatusPerformed = function(data) {
	this.loginPending = false;
	this.profileFlds_mc.openContent_mc.loginFailed(this.strings.VALIDATE_CREATE_USER_FAILED_TITLE_str, this.strings.VALIDATE_CREATE_USER_FAILED_MSG_str);
}

CheckoutUI.prototype.doNext = function(section_mc) {
	section_mc.openContent_mc.copyToSummary();
	if (section_mc.openContent_mc.isBilling && 
			section_mc.openContent_mc.useBillingForShipping_ch.getValue()) {
		section_mc.nextWidget = this.shippingMethodFlds_mc;
		this.widgetGroup.setWidgetStateSummary(this.shippingFlds_mc);
	} else {
		section_mc.nextWidget = undefined;
	}
	this.currSection = this.widgetGroup.doNext(section_mc);
}

CheckoutUI.prototype.gotUserData = function(data) {
	this.loginPending = false;
	this.progBox._visible = false;
	this.restoreUser(data);
	this.doNext(this.profileFlds_mc);
}

CheckoutUI.prototype.restore = function()
{
	if(_global.cartWidget_mc.openContent_mc.cart_lb.getLength() > 0){
		this.widgetGroup.setLocked(false);
		if(this.currSection != null && this.currSection.state != "open") {
			this.widgetGroup.toggleWidget(this.currSection);
		}
	}
	else{
		this.widgetGroup.setLocked(true);
	}
}

CheckoutUI.prototype.widgetBtnPressed = function() {
	var checkout_mc = this.widget_mc._parent;
	var currWidget = checkout_mc.widgetGroup.getCurrentWidget();
	if(currWidget == null || currWidget._target == checkout_mc.paymentFlds_mc._target || 
			currWidget.openContent_mc.validate()) {
		checkout_mc.currSection = checkout_mc.widgetGroup.toggleWidget(this.widget_mc);
		if(checkout_mc.currSection._target == checkout_mc.shippingFlds_mc._target && this.widget_mc.openContent_mc.useBillingForShipping_ch.getValue()){
			this.widget_mc.openContent_mc.useBillingForShipping_ch.setValue(false);
		}
	}
}

CheckoutUI.prototype.initUser = function(createNew, email, pass) {
	if (!this.loginPending) {
		var title = createNew ? this.strings.CREATE_USER_PROGRESS_TITLE_str :
								this.strings.LOGIN_USER_PROGRESS_TITLE_str;
		var msg = createNew ? this.strings.CREATE_USER_PROGRESS_MSG_str :
								this.strings.LOGIN_USER_PROGRESS_MSG_str;
		this.progBox = _global.progressBox(title, msg);
		this.loginPending = true;
		if (createNew) {
			this.user.addUser(email, pass);
		} else {
			this.user.getUser(email, pass);
		}
	}
}

CheckoutUI.prototype.restoreUser = function(userData) {
	var l = this.sharedAddressFields_array.length;
	var saf_array = this.sharedAddressFields_array;
	var i = 0;
	var same = true;
	// TRICKY: The loop below is a bit tricky, but the gist is that the shipping and
	// billing fields have identical names on the server and in the movie.  There's
	// a sharedAddressFields_array that maps the server fields to the movie fields and
	// that array helps make the code more compact
	while(i < 2) {
		var mc = i == 0 ? this.billingFlds_mc.openContent_mc : this.shippingFlds_mc.openContent_mc;
		var j = 0;
		for(j = 0; j < l; j+=2) {
			var prefix = i == 0 ? "home" : "shipping";
			if(saf_array[j] == "firstname" || saf_array[j] == "lastname") {
				prefix = "";
			}
			if(i == 0 && prefix != "") {
				// On first pass through array compare home and shipping fields to see if they
				// are shared.
				same &= (userData["home" + saf_array[j]] == userData["shipping" + saf_array[j]]);
			}
			if(saf_array[j] == "state" || saf_array[j] == "country") {
				this.restoreComboBox(mc[saf_array[j+1]], userData[prefix + saf_array[j]]);
			}
			else {
				mc[saf_array[j+1]].input_txt.text = ValidatorClass.prototype.trim(userData[prefix + saf_array[j]]);
			}
		}
		mc.useBillingForShipping_ch.setValue(same);
		++i;
	}
}

//----------------------------------------------------------------------
// restoreComboBox
//
// This sets the selected of a combobox to a given value.
//----------------------------------------------------------------------
CheckoutUI.prototype.restoreComboBox = function(the_cb, value) {
	var l = the_cb.getLength();
	var i = 0;
	var found = false;
	while(!found && i < l) {
		if(the_cb.getItemAt(i).data == value) {
			found = true;
			the_cb.setSelectedIndex(i);
		}
		++i;
	}
}



//----------------------------------------------------------------------
// applyAddressFldLabels
//
// 	This is a function shared by the BillingFieldsUI and the 
// 	ShippingFieldsUI classes.
//----------------------------------------------------------------------
CheckoutUI.prototype.applyAddressFldLabels = function (fld_mc)
{
	var country_array = this.cart.getCountries();
	var state_array = this.cart.getStates();
	fld_mc.useBillingForShipping_ch.setChangeHandler("toggleAddressCopy", this);
	fld_mc.firstNameFld_mc.label_txt.text = this.strings.FIRST_NAME_LBL_str;
	fld_mc.lastNameFld_mc.label_txt.text = this.strings.LAST_NAME_LBL_str;
	fld_mc.countryLabel_txt.text = this.strings.COUNTRY_CB_LBL_str;
	fld_mc.addressFld_mc.label_txt.text = this.strings.ADDRESS_LBL_str;
	fld_mc.cityFld_mc.label_txt.text = this.strings.CITY_LBL_str;
	fld_mc.stateLabel_txt.text = this.strings.STATE_CB_US_LBL_str;
	var l = country_array.length;
	for (i=0; i<l; i++){
		fld_mc.country_cb.addItem(country_array[i], country_array[i]);
	}
	_global.sizeAndFormatCombo(fld_mc.country_cb, 200, 16); // this method found in formats.as
	var l = state_array.length;
	for (i=0; i<l; i++){
		fld_mc.state_cb.addItem(state_array[i], state_array[i]);
	}
	_global.sizeAndFormatCombo(fld_mc.state_cb, 200, 16); // this method found in formats.as
	fld_mc.zipCodeFld_mc.label_txt.text = this.strings.ZIP_LBL_str;
	fld_mc.phoneFld_mc.label_txt.text = this.strings.PHONE_LBL_str;
	this.setRequiredIcons(fld_mc);
}

//----------------------------------------------------------------------
// setRequiredIcons
//
// 	This is a function shared by the BillingFieldsUI and the 
// 	ShippingFieldsUI classes.
//----------------------------------------------------------------------
CheckoutUI.prototype.setRequiredIcons = function (fld_mc) {
	var l = this.sharedAddressFields_array.length;
	var i;
	for(i = 0; i < l; i+=2) {
		if(this.sharedAddressFields_array[i+1] != "phoneFld_mc") {
			
			fld_mc[this.sharedAddressFields_array[i+1]].statusIcon_mc.gotoAndStop("required");
		}
	}
	fld_mc.stateStatusIcon_mc.gotoAndStop("required");
	fld_mc.countryStatusIcon_mc.gotoAndStop("required");
}

//----------------------------------------------------------------------
// getPhoneValidator
//
// 	This function is used for validator access such that the 
// 	validator is created exactly once, but only if needed.
//----------------------------------------------------------------------
CheckoutUI.prototype.getPhoneValidator = function() {
	if(this.phoneValidator == undefined) {
		this.phoneValidator = new ValidatePhone(50, this.strings.VALIDATE_PHONE_ERR_MSG_str);
	}
	return this.phoneValidator;
}

//----------------------------------------------------------------------
// getZipValidator
//
// 	This function is used for validator access such that the 
// 	validator is created exactly once, but only if needed.
//----------------------------------------------------------------------
CheckoutUI.prototype.getZipValidator = function() {
	if(this.zipValidator == undefined) {
		this.zipValidator = new ValidateZipCode(50, this.strings.VALIDATE_ZIPCODE_ERROR_MSG_str);
	}
	return this.zipValidator;
}

//----------------------------------------------------------------------
// validateAddresses
//
// 	This is a function shared by the BillingFieldsUI and the 
// 	ShippingFieldsUI classes.
//----------------------------------------------------------------------
CheckoutUI.prototype.validateAddresses = function(fld_mc) {
	var isValid = true;
	this.setRequiredIcons(fld_mc);
	fld_mc.firstNameFld_mc.input_txt.text = ValidatorClass.prototype.trim(fld_mc.firstNameFld_mc.input_txt.text );
	fld_mc.lastNameFld_mc.input_txt.text = ValidatorClass.prototype.trim(fld_mc.lastNameFld_mc.input_txt.text );
	fld_mc.addressFld_mc.input_txt.text = ValidatorClass.prototype.trim(fld_mc.addressFld_mc.input_txt.text );
	fld_mc.cityFld_mc.input_txt.text = ValidatorClass.prototype.trim(fld_mc.cityFld_mc.input_txt.text );
	fld_mc.zipCodeFld_mc.input_txt.text = ValidatorClass.prototype.trim(fld_mc.zipCodeFld_mc.input_txt.text );
	fld_mc.phoneFld_mc.input_txt.text = ValidatorClass.prototype.trim(fld_mc.phoneFld_mc.input_txt.text );
	if(fld_mc.firstNameFld_mc.input_txt.text.length == 0) {
		fld_mc.firstNameFld_mc.statusIcon_mc.gotoAndStop("error");
		_global.errorBox(this.strings.VALIDATE_FIRST_NAME_ERROR_TITLE_str,
			this.strings.VALIDATE_FIRST_NAME_ERROR_MSG_str, "focus",
			_global.focuser.setFocusee(fld_mc.firstNamefld_mc.input_txt));
		isValid = false;
	}
	else if(fld_mc.lastNameFld_mc.input_txt.text.length == 0) {
		fld_mc.lastNameFld_mc.statusIcon_mc.gotoAndStop("error");
		_global.errorBox(this.strings.VALIDATE_LAST_NAME_ERROR_TITLE_STR,
			this.strings.VALIDATE_LAST_NAME_ERROR_MSG_STR, "focus",
			_global.focuser.setFocusee(fld_mc.lastNamefld_mc.input_txt));
		isValid = false;
	}
	else if(fld_mc.addressFld_mc.input_txt.text.length == 0) {
		fld_mc.addressFld_mc.statusIcon_mc.gotoAndStop("error");
		_global.errorBox(this.strings.VALIDATE_ADDRESS_ERROR_TITLE_str,
			this.strings.VALIDATE_ADDRESS_ERROR_MSG_str, "focus",
			_global.focuser.setFocusee(fld_mc.addressfld_mc.input_txt));
		isValid = false;
	}
	else if(fld_mc.cityFld_mc.input_txt.text.length == 0) {
		fld_mc.cityFld_mc.statusIcon_mc.gotoAndStop("error");
		_global.errorBox(this.strings.VALIDATE_CITY_ERROR_TITLE_str,
			this.strings.VALIDATE_CITY_ERROR_MSG_str, "focus",
			_global.focuser.setFocusee(fld_mc.cityfld_mc.input_txt));
		isValid = false;
	}
	else if(!this.getZipValidator().validate(fld_mc.zipCodeFld_mc.input_txt.text)) {
		fld_mc.zipCodeFld_mc.statusIcon_mc.gotoAndStop("error");
		_global.errorBox(this.strings.VALIDATE_ZIPCODE_ERROR_TITLE_str,
			this.strings.VALIDATE_ZIPCODE_ERROR_MSG_str, "focus",
			_global.focuser.setFocusee(fld_mc.zipCodefld_mc.input_txt));
		isValid = false;
	}
	else if(fld_mc.phoneFld_mc.input_txt.text.length > 0 &&
			!this.getPhoneValidator().validate(fld_mc.phoneFld_mc.input_txt.text)) {
		fld_mc.phoneFld_mc.statusIcon_mc.gotoAndStop("error");
		_global.errorBox(this.strings.VALIDATE_PHONE_ERROR_TITLE_str,
			this.strings.VALIDATE_PHONE_ERROR_MSG_str, "focus",
			_global.focuser.setFocusee(fld_mc.phonefld_mc.input_txt));
		isValid = false;
	}
	return isValid;
}

//----------------------------------------------------------------------
// validateAddressesAndContinue
//
// 	This is a function shared by the BillingFieldsUI and the 
// 	ShippingFieldsUI classes.
//----------------------------------------------------------------------
CheckoutUI.prototype.validateAddressesAndContinue = function() {
	var curr_mc = this._parent;
	if(this.checkout.validateAddresses(curr_mc)) {
		curr_mc.copyToSummary();
		this.checkout.storeAddressInfo(curr_mc);
		if(this.checkout.shareAddresses) {
			this.checkout.copyAddress();
		}
		this.checkout.doNext(curr_mc._parent);
	}
}

//----------------------------------------------------------------------
// storeAddressInfo
//
// Stores the address info in the user model.
//----------------------------------------------------------------------
CheckoutUI.prototype.storeAddressInfo = function(address_mc) {
	var userData = this.user.getUserData();
	var saf_array = this.sharedAddressFields_array;
	var l = saf_array.length;
	var j = 0;
	for (j = 0; j < l; j+=2) {
		var prefix = address_mc.isBilling ? "home" : "shipping";
		if (saf_array[j] == "firstname" || saf_array[j] == "lastname") {
			prefix = "";
		}
		if (saf_array[j] == "state" || saf_array[j] == "country") {
			userData[prefix + saf_array[j]] = address_mc[saf_array[j+1]].getSelectedItem().data;
		} else {
			userData[prefix + saf_array[j]] = address_mc[saf_array[j+1]].input_txt.text;
		}
	}
}

//----------------------------------------------------------------------
// toggleAddressCopy
//----------------------------------------------------------------------
CheckoutUI.prototype.toggleAddressCopy = function (shouldCopy_ch) {
	this.shareAddresses = shouldCopy_ch.getValue();
	var other_ch = this.shippingFlds_mc.openContent_mc.useBillingForShipping_ch;
	if(!shouldCopy_ch.controller.isBilling) {
		other_ch = this.billingFlds_mc.openContent_mc.useBillingForShipping_ch;
		if (shouldCopy_ch.getValue()){
			this.copyAddress();
		}
	}
	if(shouldCopy_ch.getValue() != other_ch.getValue()) {
		other_ch.setValue(shouldCopy_ch.getValue());
	}
}

//----------------------------------------------------------------------
// copyAddress
//----------------------------------------------------------------------
CheckoutUI.prototype.copyAddress = function () {
	var src_mc = this.billingFlds_mc.openContent_mc;
	var dest_mc = this.shippingFlds_mc.openContent_mc;
	var l = this.sharedAddressFields_array.length;
	for (i=0; i<l; i+=2){
		var currFld = this.sharedAddressFields_array[i+1];
		if(currFld != "state_cb" && currFld != "country_cb") {
			dest_mc[currFld].input_txt.text = src_mc[currFld].input_txt.text;
		}
	}
	dest_mc.country_cb.setSelectedIndex(src_mc.country_cb.getSelectedIndex());
	dest_mc.state_cb.setSelectedIndex(src_mc.state_cb.getSelectedIndex());
	this.storeAddressInfo(dest_mc);
	dest_mc.copyToSummary();
}


//----------------------------------------------------------------------
// setPromoCode
//----------------------------------------------------------------------
CheckoutUI.prototype.setPromoCode = function (promoCode) {
	this.cart.applyDiscount(promoCode);
}

//----------------------------------------------------------------------
// continueShopping
//
// 	Called when exit checkout is clicked.
//----------------------------------------------------------------------
CheckoutUI.prototype.continueShopping = function () {
	this.cart.continueShopping(false);
}

//----------------------------------------------------------------------
// setShippingCharge
//
// Tell the cart that shipping charge has changed so the cart can update
// the total cost.
//----------------------------------------------------------------------
CheckoutUI.prototype.setShippingCharge= function (cost) {
	this.cart.setShippingCharge(cost);
}

//----------------------------------------------------------------------
// sendOrder
//
// Sending the order is a two stage process.  first, the user data
// must be committed to the server, then the actual order is sent.
//----------------------------------------------------------------------
CheckoutUI.prototype.sendOrder = function () {
	this.widgetGroup.setLocked(true);
	_global.progressBox(this.strings.SUBMITTING_ORDER_PROGRESS_TITLE_str, 
				this.strings.SUBMITTING_USER_PROGRESS_MSG_str);
	this.user.updateUser();
}

CheckoutUI.prototype.continueSendOrder = function () {
	_global.progressBox(this.strings.SUBMITTING_ORDER_PROGRESS_TITLE_str, 
				this.strings.SUBMITTING_ORDER_PROGRESS_MSG_str);
	this.finishSendOrder();
}

CheckoutUI.prototype.finishSendOrder = function () {
	this.cart.continueShopping(true, true);
	_global.confirmBox(this.strings.CONFIRM_ORDER_TITLE_str, this.strings.CONFIRM_ORDER_MSG_str);
}

//----------------------------------------------------------------------
// initSwitchUserUI
//
// This is called if the user visits the login section a second time.
//----------------------------------------------------------------------
CheckoutUI.prototype.initSwitchUserUI = function()
{
	this.profileFlds_mc.headBG_mc.editLabel_txt.text = _global.appStrings.PROFILE_FLDS_LOGOUT_EDIT_LBL_str;
	this.profileFlds_mc.headBG_mc.widget_mc = this.profileFlds_mc;
	this.profileFlds_mc.openContent_mc.hint_txt.text = _global.appStrings.PROFILE_FLDS_LOGOUT_1_HINT_str + this.profileFlds_mc.openContent_mc.emailFld_mc.input_txt.text;
	this.profileFlds_mc.openContent_mc.hint_txt.text += newline +  _global.appStrings.PROFILE_FLDS_LOGOUT_2_HINT_str;		
}

#endinitclip

//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
