// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip 
//
//
/*
//
ShippingMethodsUI class

	The ShippingMethodsUI class encapsulates all UI behavior of the
	ShippingMethods section of the checkout.

	This code is meant to initialize the section and provide uniform access
	to the ShippingMethods data object.

	This file is associated with a library movie clip symbol.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class

			Frame:				1

			Library Symbol:		shippingMethodsFldsOpenContent_mc

			Library Path:		CheckoutWidget/shippingMethodsFlds/shippingMethodsFldsOpenContent_mc
//
*/
//

//----------------------------------------------------------------------
//ShippingMethodsUI
//
// As with all the CheckoutUI classes, this class encapsulates the 
// behaviour of the "open" state of this checkout widget.
//
// The "closed" state of this widget can be referenced via:
//
// 	this._parent.summaryContent_mc
//
//----------------------------------------------------------------------
function ShippingMethodsUI() {
}

// Associate the ShippingMethodsUI class with the authortime
// shippingMethodsFldsOpenContent_mc instance
Object.registerClass("ShippingMethodsUISymbol", ShippingMethodsUI);

ShippingMethodsUI.prototype = new MovieClip();

//----------------------------------------------------------------------
// init
//
//	This function initializes the fields in the "open" view of
//	the shipping methods section.
//----------------------------------------------------------------------
ShippingMethodsUI.prototype.init = function(tabController, firstTab, strings, shipMethods_rs, checkout) {
	this.checkout = checkout;
	var tabCount = firstTab;
	this.strings = strings;
	this.hint_txt.text = strings.SHIPPING_METHODS_FLDS_HINT_str;
	this.shippingMethodLabel_txt.text = strings.SHIPPING_METHOD_LBL_str;
	tabController.setTab("ShippingMethodsUI", this.shippingMethod_cb, tabCount++);
	tabController.setTab("ShippingMethodsUI", this.promotionCodeFld_mc.input_txt, tabCount++);
	tabController.setTab("ShippingMethodsUI", this.continue_ib, tabCount++);
	_global.sizeAndFormatIconBtn(this.continue_ib, strings.CONTINUE_BTN_LBL_str, _global.formIconBtnFormat);
	this.continue_ib.setChangeHandler("validateAndNotifyCheckout", this);
	this.estDeliveryDateLabel_txt.text = strings.EST_DELIVERY_DATE_LBL_str;
	this.addShipMethods(shipMethods_rs);
	_global.sizeAndFormatCombo(this.shippingMethod_cb, 250, 16); // this method found in formats.as

	this.promotionCodeFld_mc.label_txt.text = strings.PROMOTION_CODE_LBL_str;
	this.shippingMethod_cb.setChangeHandler("changeShipMethod", this);
	this.shippingMethod_cb.setSelectedIndex(0);
}

ShippingMethodsUI.prototype.addShipMethods = function(shipMethods_rs) {
	var num = shipMethods_rs.getLength();
	for (var i = 0; i < num; ++i) {
		var item_record = shipMethods_rs.getItemAt(i);
		var label = item_record["shippingname"] + " - " + 
			_global.formatForCurrency(item_record["shippingPrice"]);
		this.shippingMethod_cb.addItem(label, item_record);
	}
}

ShippingMethodsUI.prototype.changeShipMethod = function (shipMethod_cb) {
	var estDate_date = new Date();
	var shipMethod = shipMethod_cb.getValue();
	estDate_date.setTime(Number(Number(estDate_date.getTime())+
				Number(shipMethod["shippingDays"]*24*60*60*1000)));
	this.estDeliveryDate_txt.text = _global.formatShipDate(estDate_date);
	this.checkout.setShippingCharge(shipMethod["shippingPrice"]);
}
//----------------------------------------------------------------------
// copyToSummary
//
// 	This function is called after the widget's been validated and is
// 	collapsing.
//----------------------------------------------------------------------
ShippingMethodsUI.prototype.copyToSummary = function()
{
	var summary_txt = this._parent.summaryContent_mc.summary_txt;
	var promoCode_str = this.promotionCodeFld_mc.input_txt.text;
	var summaryMsg_str = this.shippingMethod_cb.getSelectedItem().label + newline;
	summaryMsg_str += _global.appStrings.EST_DELIVERY_DATE_LBL_str + " " + this.estDeliveryDate_txt.text + newline;
	if(promoCode_str.length > 0){
		summaryMsg_str += _global.appStrings.PROMOTION_CODE_LBL_str + " " + promoCode_str;
	}
	summary_txt.text = summaryMsg_str;
}

//----------------------------------------------------------------------
// opening
//
// 	This function is called when the UI widget is opening.
//----------------------------------------------------------------------
ShippingMethodsUI.prototype.opening = function() {
	Selection.setFocus(this.shippingMethod_cb);
}

//----------------------------------------------------------------------
// validateAndNotifyCheckout
//----------------------------------------------------------------------
ShippingMethodsUI.prototype.validateAndNotifyCheckout = function() {
	if(this.validate()) {
		this.checkout.doNext(this._parent);
	}
}

//----------------------------------------------------------------------
// validate
//
// 	This function should return a boolean indicating whether the
// 	validation was successful.
//----------------------------------------------------------------------
ShippingMethodsUI.prototype.validate = function() {
	// there's no validation to be done for this demo
	this.checkout.setPromoCode(this.promotionCodeFld_mc.input_txt.text);
	return true;
}

#endinitclip 
//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
