// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip 
//
//
/*
//
SearchUI class

	The SearchUI class encapsulates all UI behavior pertaining to maintaining a
	Search of a browsing session.

	This is meant to be used as a singleton: i.e. It's not meant to be
	instantiated directly and all access should go through the _global.searchWidget_mc
	object.


	This file is associated with a library movie clip symbol.

	#include info for this file:

			FLA: 				main.fla

			Layer:				Actions : Class

			Frame:				1

			Library Symbol:		searchWidget_mc

			Library Path:		widgetGroup/searchWidget/searchWidget_mc
//
*/
//

//----------------------------------------------------------------------
//SearchUI
//----------------------------------------------------------------------
function SearchUI() {
	_global.searchWidget_mc	= this;
}

// Associate the SearchUI class with the authortime itemBrowsing_mc instance
Object.registerClass("SearchSymbol", SearchUI);


SearchUI.prototype = new MovieClip();

//----------------------------------------------------------------------
// init
//----------------------------------------------------------------------
SearchUI.prototype.init = function(tabController, strings, catalog) {
	this.tabController = tabController;
	this.strings = strings;
	this.catalog = catalog;
	this.isOpen = false;
	this.openContent_mc.searchResults_lb.setItemSymbol("FPCCatColorListItemSymbol");
	this.openContent_mc.searchResults_lb.measureItmHgt();
	_global.sizeAndFormatListBox(this.openContent_mc.searchResults_lb, 12);
	this.openContent_mc.searchResults_lb.setChangeHandler("gotoProduct", this);
	this.widgetLabel_txt.text = this.strings.SEARCH_WIDGET_LBL_str;
	this.search_ib.setChangeHandler("doSearch", this);
	_global.sizeAndFormatIconBtn(this.search_ib, strings.SEARCH_WIDGET_BTN_LBL_str, _global.hiliteWidgetIconBtnFormat);
	this.searchInput_txt.controller = this;
	this.searchInput_txt.onKeyDown = SearchUI.prototype.checkForEnterKey;
	this.searchInput_txt.onSetFocus = SearchUI.prototype.setupEnterKeyListener;
	this.searchInput_txt.onKillFocus = SearchUI.prototype.removeEnterKeyListener;

	this.tabController.setTab("SearchUI", this.headBG_mc, 
			TabConstants.prototype.SearchUIStartTab);
	this.tabController.setTab("SearchUI", this.searchInput_txt, 
			TabConstants.prototype.SearchUIStartTab + 1);
	this.tabController.setTab("SearchUI", this.search_ib, 
			TabConstants.prototype.SearchUIStartTab + 2);
	_global.initStyles();
}

SearchUI.prototype.startListening = function() {
	seasar.event.Broadcaster.addEventListener("searchProducts", this);
}

SearchUI.prototype.searchProductsPerformed = function(data) {
	this.drawSearchResults(data);
}

//----------------------------------------------------------------------
// gotoProduct
//----------------------------------------------------------------------
SearchUI.prototype.gotoProduct = function (lb) {
	var productRecord = lb.getSelectedItem().data;
	if(productRecord != undefined && productRecord["CATEGORYOID"] != -1) {
		this.catalog.changeSelectedProduct(productRecord["CATEGORYOID"], 
				productRecord["PRODUCTOID"]);
	}
}

//----------------------------------------------------------------------
// doSearch
//----------------------------------------------------------------------
SearchUI.prototype.doSearch = function()
{
	var str = this.searchInput_txt.text;
	if(str == "jozsi" || str == "Jozsi"){
		str = "american shorthair";
	}
	if(str.length > 0){
		this.catalog.searchProducts(str);
	}
}

//----------------------------------------------------------------------
// drawSearchResults
//----------------------------------------------------------------------
SearchUI.prototype.drawSearchResults = function(recordset)
{
	if(!this.isOpen) {
		this.headBG_mc.onPress();
	}
	this.openContent_mc.searchResults_lb.removeAll();
	if(recordset.getLength() < 1 ){
		var anItem = new Object();
			anItem["COLOR"] = "0xFFFFFF";
			anItem["CATEGORYOID"] = -1;
			anItem["PRODUCTOID"] = -1;
			this.openContent_mc.searchResults_lb.addItem(this.strings.SEARCH_NO_RESULTS_FOUND_FOR_str+this.searchInput_txt.text,
					anItem);
	}
	else{
		var i;
		var l = recordSet.getLength();
		for (i=0; i<l; i++) {
			var anItem = recordSet.getItemAt(i);
			anItem["COLOR"] = "0x" + anItem["COLOR"];
			this.openContent_mc.searchResults_lb.addItem(anItem["CATEGORYDISPLAYNAME"] + ": "+anItem["NAME"], anItem);
		}
	}
	this.isSearching = false;
}

// <enter key handler for search text field>

//----------------------------------------------------------------------
// checkForEnterKey
//
// In function below: this = searchInput_txt field.
//----------------------------------------------------------------------
SearchUI.prototype.checkForEnterKey = function() {
	if(Key.getCode() == Key.ENTER) {
		this.controller.doSearch();
	}
}

//----------------------------------------------------------------------
// setupEnterKeyListener
//
// In function below: this = searchInput_txt field.
//----------------------------------------------------------------------
SearchUI.prototype.setupEnterKeyListener = function() {
	Key.addListener(this);
}

//----------------------------------------------------------------------
// removeEnterKeyListener
//
// In function below: this = searchInput_txt field.
//----------------------------------------------------------------------
SearchUI.prototype.removeEnterKeyListener = function() {
	Key.removeListener(this);
}
// </enter key handler for search text field>

//----------------------------------------------------------------------
// toggleWidget
//
// Called from WidgetGroup.
//----------------------------------------------------------------------
SearchUI.prototype.toggleWidget = function(isOpening) {
	this.isOpen = isOpening;
	this.tabController.setTab("SearchUI", this.openContent_mc.searchResults_lb, 
			isOpening ?  TabConstants.prototype.SearchUIStartTab + 3 : undefined);
}

#endinitclip
//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
