package test.petmarket.rule.user;

import java.util.Map;

import org.seasar.nazuna.Nazuna;
import org.seasar.nazuna.unit.NazunaTestCase;
import org.seasar.util.SeasarException;

import petmarket.rule.RuleNames;

public class GetUserTest extends NazunaTestCase implements RuleNames {

	public GetUserTest(String arg0) {
		super(arg0);
	}

	public void testExecute() throws Exception {
		Map user =
			(Map) Nazuna.execute(ADD_USER, "hoge@isid.co.jp", "hogepassword");
		Map user2 =
			(Map) Nazuna.execute(GET_USER, "hoge@isid.co.jp", "hogepassword");
		assertEquals("1", user.get("useroid"), user2.get("useroid"));
		assertEquals("2", user.get("email"), user2.get("email"));
		assertEquals("3", user.get("password"), user2.get("password"));
	}

	public void testNotCorrect() throws Exception {
		try {
			Map user2 =
				(Map) Nazuna.execute(
					GET_USER,
					"hoge@isid.co.jp",
					"hogepassword");
		} catch (SeasarException ex) {
			if (ex.getMessageCode().equals("EPMT0001")) {
				System.out.println(ex);
			} else {
				throw ex;
			}
		}
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(GetUserTest.class);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}
}
