package test.petmarket.rule.user;

import java.util.Map;

import org.seasar.nazuna.Nazuna;
import org.seasar.nazuna.unit.NazunaTestCase;
import org.seasar.util.SeasarException;
import org.seasar.util.Struct;

import petmarket.rule.RuleNames;


public class UpdateHomeAddressTest extends NazunaTestCase implements RuleNames {

	public UpdateHomeAddressTest(String arg0) {
		super(arg0);
	}

	public void testValidateUser() throws Exception {
		try {
			Nazuna.executeUpdate(UPDATE_HOME_ADDRESS, (Object) null);
			fail("1");
		} catch (SeasarException ex) {
			System.out.println(ex);
		}
	}

	public void testExecute() throws Exception {
		Struct user = (Struct) Nazuna.execute(ADD_USER, "hoge", "hoge");
		user.put("homestreet1", "homestreet1");
		user.put("homestreet2", "homestreet2");
		user.put("homecity", "homecity");
		user.put("homestate", "homestate");
		user.put("homecountry", "homecountry");
		user.put("homezip", "homezip");
		int num = Nazuna.executeUpdate(UPDATE_HOME_ADDRESS, (Object) user);
		assertEquals("1", 1, num);
		Map user2 = (Map) Nazuna.executeSingleQuery(GET_USER, "hoge");
		assertNotNull("2", user2);
		assertEquals("3", "homestreet1", user2.get("homestreet1"));
		assertEquals("4", "homestreet2", user2.get("homestreet2"));
		assertEquals("5", "homecity", user2.get("homecity"));
		assertEquals("6", "homestate", user2.get("homestate"));
		assertEquals("7", "homecountry", user2.get("homecountry"));
		assertEquals("8", "homezip", user2.get("homezip"));
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(UpdateHomeAddressTest.class);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}
}
