// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip 3
/*
		FPCCartListItemClass

		This is a customized List Item for the cart listbox.  The cart listbox
		is standard Flash MX listbox with custom list items that support:

		- color coded category item

		- multiple line display

		- editable quantity field

		This file is included in the fui_components.fla file's Library in the
		"Actions : Class" layer of the FPCCartListItemSymbol movie clip

		The code uses the standard means of creating a custom listbox:

		- the FPCCartListItemClass is derived from the FSelectableItemClass 

		- the displayContent method is overridden

*/

//----------------------------------------------------------------------
//FPCCartListItemClass
//----------------------------------------------------------------------
function FPCCartListItemClass()
{
}

FPCCartListItemClass.prototype = new FSelectableItemClass();
Object.registerClass("FPCCartListItemSymbol", FPCCartListItemClass);


//----------------------------------------------------------------------
// displayContent
//
//  this is the function that must be implemented to display the custom
//  list item content
//----------------------------------------------------------------------
FPCCartListItemClass.prototype.displayContent = function(itmObj, selected)
{
	var catColor = new Color(this.colorSwatch);
	if(itmObj.label != null){
		var lb = this.controller;
		var itemRecord = itmObj.data;
		// TRICKY: to speed up initialization time, don't create the spin button 
		// until the list item is actually selected- it's not needed until then.
		if(selected || this.qtyOrdered_spin != null) {
			if(this.qtyOrdered_spin == null) {
				this.qtyOrdered_txt.removeMovieClip();
				this.attachMovie("FSpinButtonFieldSymbol", "qtyOrdered_spin", 16);
				this.qtyOrdered_spin.setSize(40,17);
				this.qtyOrdered_spin._x = 162;
				this.qtyOrdered_spin._y = _global.snapCoordToPixel(1, this);
				this.qtyOrdered_spin.tabEnabled = true;
				this.qtyOrdered_spin.setMinimum(1);
				this.qtyOrdered_spin.setInterval(1);
			}
			lb.controller.tabController.setTab("CartUIListItems", this.qtyOrdered_spin.myTextField,
					selected ? lb.controller.spinButtonTabIndex : undefined);

			this.qtyOrdered_spin.setMaximum(itemRecord["QUANTITY"]);
			this.qtyOrdered_spin.setValue(itemRecord["ITEMQUANTITY"]);
			this.qtyOrdered_spin.setEditable(selected);
			this.qtyOrdered_spin.setChangeHandler("itemQtySpinBtnChanged", lb.controller);
			this.qtyOrdered_spin.setRate(1000);
			this.qtyOrdered_spin.itm = itemRecord;
			this.qtyOrdered_spin._visible = true;
		}
		else if(this.qtyOrdered_txt == null) {
			this.createTextField("qtyOrdered_txt", 16, 169, 1, 20, 20);
			this.qtyOrdered_txt.type = "dynamic";
			this.qtyOrdered_txt.border = false;
			this.qtyOrdered_txt.background = false;
			this.qtyOrdered_txt.embedFonts = true;
			this.qtyOrdered_txt.setNewTextFormat(_global.smallTextRight_fmt);
			this.qtyOrdered_txt.text = itemRecord["ITEMQUANTITY"];
			this.qtyOrdered_txt.restrict = "0-9";
		}
		else {
			this.qtyOrdered_txt._visible = true;
		}

		this.productName_txt.text = itemRecord["NAME"];
		this.itemName_txt.text = itemRecord["ITEMNAME"];
		this.itemPrice_txt.text = _global.formatForCurrency(itemRecord["LISTPRICE"]);

		catColor.setRGB(itmObj.data.COLOR);
	}
	else{
		catColor.setRGB(0xFFFFFF);
		if(this.qtyOrdered_txt != null) this.qtyOrdered_txt._visible = false;
		if(this.qtyOrdered_spin != null) this.qtyOrdered_spin._visible = false;
		this.productName_txt.text = "";
		this.itemName_txt.text = "";
		this.itemPrice_txt.text = "";
	}

}



#endinitclip
