#include "NetServices.as"
#include "seasar/lang/SObject.as"
#include "seasar/unit/TestCase.as"
#include "seasar/event/Broadcaster.as"
#include "petmarket/service/user/User.as"
#include "petmarket/service/user/AddUser.as"

if (test.petmarket.service.user.AddUserTest === undefined) {
	seasar.lang.SObject.defineClass("test.petmarket.service.user.AddUserTest",
		seasar.unit.TestCase, ["user", "service"]);
	
	var proto = test.petmarket.service.user.AddUserTest.prototype;
	
	proto.setUp = function() {
		NetServices.setDefaultGatewayUrl("http://localhost:8080/petmarket/gateway");
		var conn = NetServices.createGatewayConnection();
		this.user = new petmarket.service.user.User(conn);
		this.service = new petmarket.service.user.AddUser(conn, this.user);
	}
	
	proto.tearDown = function() {
		this.user = null;
		this.service = null;
	}
	
	proto.testExecute = function() {
		var listener = new Object();
		listener.user = this.user;
		listener.addUserPerformed = function(data) {
			trace("listener.addUserPerformed:" + data);
			trace("listener.user.userData:" + this.user.userData);
		}
		seasar.event.Broadcaster.addEventListener("addUser", listener);
		this.service.execute("hoge", "hoge");
	}

	delete proto;
}