package org.seasar.extension.dataset.impl;

import java.util.ArrayList;
import java.util.List;

import org.seasar.extension.dataset.ColumnNotFoundRuntimeException;
import org.seasar.extension.dataset.DataColumn;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataTable;
import org.seasar.framework.util.ArrayMap;

/**
 * @author higa
 *
 */
public class DataTableImpl implements DataTable {

	private String tableName_;
	private List rows_ = new ArrayList();
	private ArrayMap columns_ = new ArrayMap();

	public DataTableImpl(String tableName) {
		tableName_ = tableName;
	}

	/**
	 * @see org.seasar.extension.dataset.DataTable#getTableName()
	 */
	public String getTableName() {
		return tableName_;
	}

	/**
	 * @see org.seasar.extension.dataset.DataTable#getRowSize()
	 */
	public int getRowSize() {
		return rows_.size();
	}

	/**
	 * @see org.seasar.extension.dataset.DataTable#getRow(int)
	 */
	public DataRow getRow(int index) {
		return (DataRow) rows_.get(index);
	}

	/**
	 * @see org.seasar.extension.dataset.DataTable#addRow(org.seasar.extension.dataset.DataRow)
	 */
	public void addRow(DataRow row) {
		rows_.add(row);
	}

	/**
	 * @see org.seasar.extension.dataset.DataTable#getColumnSize()
	 */
	public int getColumnSize() {
		return columns_.size();
	}

	/**
	 * @see org.seasar.extension.dataset.DataTable#getColumn(int)
	 */
	public DataColumn getColumn(int index) {
		return (DataColumn) columns_.get(index);
	}

	public DataColumn getColumn(String columnName)
		throws ColumnNotFoundRuntimeException {

		DataColumn column = (DataColumn) columns_.get(columnName);
		if (column == null) {
			throw new ColumnNotFoundRuntimeException(columnName);
		}
		return column;
	}
	
	/**
	 * @see org.seasar.extension.dataset.DataTable#addColumn(org.seasar.extension.dataset.DataColumn)
	 */
	public void addColumn(DataColumn column) {
		columns_.put(column.getColumnName(), column);
	}
}
