package org.seasar.framework.container.assembler;

import org.seasar.framework.aop.proxy.AopProxy;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.IllegalConstructorRuntimeException;

/**
 * @author higa
 *
 */
public final class ManualConstructorAssembler
	extends AbstractConstructorAssembler {

	/**
	 * @param componentDef
	 */
	public ManualConstructorAssembler(ComponentDef componentDef) {
		super(componentDef);
	}

	public Object assemble()
		throws IllegalConstructorRuntimeException {

		Object[] args = new Object[getComponentDef().getArgDefSize()];
		for (int i = 0; i < args.length; ++i) {
			try {
				args[i] = getComponentDef().getArgDef(i).getValue();
			} catch (ComponentNotFoundRuntimeException cause) {
				throw new IllegalConstructorRuntimeException(
					getComponentDef().getComponentClass(),
					cause);
			}

		}
		BeanDesc beanDesc =
			BeanDescFactory.getBeanDesc(getComponentDef().getComponentClass());
		if (getComponentDef().getAspectDefSize() > 0) {
			AopProxy aopProxy = createAopProxy();
			return aopProxy.create(
				beanDesc.getSuitableConstructor(args).getParameterTypes(),
				args);
		} else {
			return beanDesc.newInstance(args);
		}

	}
}
