package org.seasar.framework.container.impl;

import org.seasar.framework.aop.AroundAdvice;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.AspectImpl;
import org.seasar.framework.container.AspectDef;

/**
 * @author higa
 *
 */
public class AspectDefImpl extends ArgDefImpl implements AspectDef {

	private Pointcut pointcut_;

	public AspectDefImpl() {
	}

	public AspectDefImpl(Pointcut pointcut) {
		pointcut_ = pointcut;
	}
	
	public AspectDefImpl(AroundAdvice advice) {
		setValue(advice);
	}

	public AspectDefImpl(AroundAdvice advice, Pointcut pointcut) {
		setValue(advice);
		pointcut_ = pointcut;
	}

	/**
	 * @see org.seasar.framework.container.AspectDef#getAspect()
	 */
	public Aspect getAspect() {
		AroundAdvice advice = (AroundAdvice) getValue();
		return new AspectImpl(advice, pointcut_);
	}
}
