package org.seasar.framework.sel.boolexps;

import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.SelContext;

public final class AndExp implements BoolExpression {

	private BoolExpression arg1Exp_;
	private BoolExpression arg2Exp_;

	public AndExp(BoolExpression arg1Exp, BoolExpression arg2Exp) {
		arg1Exp_ = arg1Exp;
		arg2Exp_ = arg2Exp;
	}

	public boolean evaluate(SelContext context) {
		if (!arg1Exp_.evaluate(context)) {
			return false;
		} else {
			return arg2Exp_.evaluate(context);
		}
	}
}
